from rest_framework import serializers

from lms.users.serializers import UserDetailLabSerializer

from ..models import Tutor


# LABAPI Serializers
# ===============
class TutorDetailLabSerializer(serializers.ModelSerializer):
    user = UserDetailLabSerializer()
    name = serializers.CharField(source='name_common')
    url = serializers.CharField(source='url_common')

    class Meta:
        model = Tutor
        fields = (
            'id', 'is_internal', 'user', 'name', 'email', 'url', 'position', 'is_active',
        )
        read_only_fields = fields


class TutorListLabSerializer(serializers.ModelSerializer):
    user = UserDetailLabSerializer()
    name = serializers.CharField(source='name_common')
    url = serializers.CharField(source='url_common')

    class Meta:
        model = Tutor
        fields = (
            'id', 'is_internal', 'user', 'name', 'email', 'url', 'position', 'is_active',
        )
        read_only_fields = fields


# API Serializers
# ===============
class TutorDetailSerializer(serializers.ModelSerializer):
    user = UserDetailLabSerializer()
    name = serializers.CharField(source='name_common')
    url = serializers.CharField(source='url_common')

    class Meta:
        model = Tutor
        fields = (
            'id', 'is_internal', 'user', 'name', 'email', 'url', 'position'
        )
        read_only_fields = fields
