from django.conf import settings
from django.core.exceptions import ValidationError
from django.utils.translation import gettext_lazy as _


def validate_course_slug(value) -> None:
    """
    Валидация slug курса в serializer'e
    """
    if value in settings.COURSE_RESERVED_SLUGS:
        raise ValidationError(
            _("'{value}' нельзя использовать в качестве кода курса").format(value=value),
            code='invalid',
        )
