from django.shortcuts import get_object_or_404

from ..models import Course


class GetCourseMixin:
    """
    Миксин для получения курса из текущего объекта
    """
    def get_course(self, obj=None):
        if obj is not None:
            return obj.course

        course_qs = Course.objects.all()
        if self.action == 'create':
            return get_object_or_404(course_qs, pk=self.request.data.get('course_id'))
        if self.action == 'list':
            return get_object_or_404(course_qs, pk=self.kwargs.get('pk'))
