from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.pagination import LimitOffsetAllPagination
from lms.core.views.viewsets import APIModelViewSet

from ..models import Course
from ..serializers.course_index import CourseIndexSerializer


class CourseIndexViewSet(APIModelViewSet):
    """
    Ручки для индексации внутренним поиском.
    @see https://wiki.yandex-team.ru/intranetpoisk/sourceapi/
    """
    serializer_class = CourseIndexSerializer
    queryset = Course.objects.filter(
        is_archive=False,
        is_active=True,
        show_in_catalog=True,
        course_type=Course.TypeChoices.COURSE
    )
    pagination_class = LimitOffsetAllPagination

    @extend_schema(
        summary=gettext(
            "Список курсов для индексирования внутренним поиском"
        )
    )
    def list(self, request, *args, **kwargs):
        return super().list(request, *args, **kwargs)

    @extend_schema(
        summary=gettext(
            "Информация по курсу для индексирования внутренним поиском"
        )
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)
