# Generated by Django 2.2.13 on 2020-07-07 01:24

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('courses', '0002_course_override'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Enrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('enroll_type', models.CharField(choices=[('instant', 'Автоматически'), ('manual', 'Ручное')], default='manual', max_length=20, verbose_name='тип')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('summary', models.CharField(blank=True, max_length=500, verbose_name='краткое описание')),
                ('options', django.contrib.postgres.fields.jsonb.JSONField(default={}, verbose_name='параметры')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
                ('is_default', models.BooleanField(default=False, verbose_name='по умолчанию')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='enrollments', to='courses.Course', verbose_name='курс')),
            ],
            options={
                'verbose_name': 'метод зачисления',
                'verbose_name_plural': 'методы зачисления',
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='EnrolledUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('parameters', django.contrib.postgres.fields.jsonb.JSONField(default={}, verbose_name='параметры')),
                ('status', models.CharField(choices=[('pending', 'на рассмотрении'), ('enrolled', 'зачислен'), ('rejected', 'отклонен'), ('expelled', 'отчислен'), ('resumed', 'восстановлен')], default='pending', max_length=20, verbose_name='статус')),
                ('comments', models.TextField(blank=True, verbose_name='комментарии')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='enrolled_users', to='courses.Course', verbose_name='курс')),
                ('enrollment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='enrolled_users', to='enrollments.Enrollment', verbose_name='метод зачисления')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='enrolled_users', to='courses.CourseGroup', verbose_name='группа')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enrolled_to', to=settings.AUTH_USER_MODEL, verbose_name='студент')),
            ],
            options={
                'verbose_name': 'заявка на зачисление',
                'verbose_name_plural': 'заявки на зачисление',
                'ordering': ('-created',),
                'unique_together': {('course', 'enrollment', 'user', 'status')},
            },
        ),
    ]
