# Generated by Django 2.2.13 on 2020-08-24 06:49

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('enrollments', '0003_fix_json_fields'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnrollSurveyForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('slug', models.SlugField(max_length=255, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('summary', models.CharField(blank=True, max_length=500, verbose_name='краткое описание')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='tracker_forms', to=settings.AUTH_USER_MODEL, verbose_name='создано')),
            ],
            options={
                'verbose_name': 'Анкета при зачислении',
                'verbose_name_plural': 'Анкеты при зачислении',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='EnrollSurveyFormField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(help_text='Только латиница', max_length=255, verbose_name='название поля')),
                ('field_type', models.CharField(choices=[('text', 'Текст'), ('textarea', 'Много текста'), ('number', 'Число'), ('url', 'Ссылка'), ('email', 'Email'), ('select', 'Выпадающий список'), ('select_weekdays', 'Выбор дней недели и времени')], default='text', max_length=20, verbose_name='тип')),
                ('title', models.CharField(max_length=255, verbose_name='заголовок')),
                ('description', models.TextField(blank=True, help_text='Выводится под полем', verbose_name='описание')),
                ('placeholder', models.CharField(blank=True, help_text='Выводится внутри поля', max_length=255, verbose_name='подсказка')),
                ('parameters', django.contrib.postgres.fields.jsonb.JSONField(default=dict, verbose_name='параметры')),
                ('default_value', models.CharField(blank=True, help_text='Значение по умолчанию', max_length=255, verbose_name='по умолчанию')),
                ('is_required', models.BooleanField(default=False, verbose_name='обязательное поле')),
                ('is_hidden', models.BooleanField(default=False, verbose_name='скрыть')),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fields', to='enrollments.EnrollSurveyForm', verbose_name='форма')),
            ],
            options={
                'verbose_name': 'поле для формы',
                'verbose_name_plural': 'поля для формы',
                'ordering': ('order',),
            },
        ),
    ]
