# Generated by Django 3.0.11 on 2021-05-21 10:37

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0042_course_history'),
        ('enrollments', '0017_survey_field_dataset'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalEnrolledUser',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('hrdb_id', models.IntegerField(blank=True, db_index=True, help_text='Идентификатор в базе HRDB', null=True, verbose_name='ID в HRDB')),
                ('survey_data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, verbose_name='данные по анкете')),
                ('hrdb_survey_data', models.TextField(blank=True, verbose_name='данные по анкете из hrdb')),
                ('status', models.CharField(choices=[('pending', 'на рассмотрении'), ('enrolled', 'зачислен'), ('rejected', 'отклонен'), ('completed', 'завершил обучение')], default='pending', max_length=20, verbose_name='статус')),
                ('comments', models.TextField(blank=True, verbose_name='комментарии')),
                ('groups', models.TextField(blank=True, help_text='строка подразделений работника в момент подачи заявки, разделенных /', verbose_name='подразделения в момент подачи заявки')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('course', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Course', verbose_name='курс')),
                ('course_student', models.ForeignKey(blank=True, db_constraint=False, help_text='студент, созданный по этой заявке', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseStudent', verbose_name='студент')),
                ('enrollment', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enrollments.Enrollment', verbose_name='метод зачисления')),
                ('group', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseGroup', verbose_name='группа')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('survey', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enrollments.EnrollSurvey', verbose_name='анкета при зачислении')),
                ('user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='студент')),
            ],
            options={
                'verbose_name': 'historical заявка на зачисление',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
