from collections import OrderedDict

from rest_framework import serializers


class DatasetSerializer(serializers.Serializer):
    value = serializers.CharField()
    content = serializers.CharField()

    lookup_value = 'id'
    lookup_content = '__str__'

    def to_representation(self, instance) -> OrderedDict:
        value = getattr(instance, self.lookup_value)
        content = getattr(instance, self.lookup_content)

        return OrderedDict({
            'value': str(value() if callable(value) else value),
            'content': str(content() if callable(content) else content),
        })
