from django.urls import include, path

from .datasets import DATASETS

urlpatterns = [
    path(
        '',
        include(
            [
                path(
                    dataset_name,
                    dataset.as_view(),
                    name=f"dataset-{dataset_name.replace('_', '-').replace('/', '')}",
                )
                for dataset_name, dataset in DATASETS.items()
            ]
        )
    ),
]
