from typing import Any, Generator, Iterable


def flatten_options(opts: Iterable) -> Generator[Any, None, None]:
    """
    Генерирует плоский список объектов из вложенных списков
    """
    if isinstance(opts, (list, tuple)):
        for item in opts:
            yield from flatten_options(item)
    else:
        yield opts
