from django_admin_listfilter_dropdown.filters import RelatedOnlyDropdownFilter

from django.contrib import admin

from .models import FirewallRule, GroupFirewallRule, TeamFirewallRule


@admin.register(FirewallRule)
class FirewallRuleAdmin(admin.ModelAdmin):
    list_display = ('slug', 'summary', 'created', 'modified')
    fields = ('slug', 'summary',)


@admin.register(GroupFirewallRule)
class GroupFirewallRuleAdmin(admin.ModelAdmin):
    list_display = ('group', 'rule', 'is_staff', 'created', 'modified')
    list_filter = (
        ('group', RelatedOnlyDropdownFilter),
        'rule',
    )
    raw_id_fields = ('group',)
    fields = ('group', 'rule', 'is_staff')


@admin.register(TeamFirewallRule)
class TeamFirewallRuleAdmin(admin.ModelAdmin):
    list_display = ('team', 'rule', 'created', 'modified')
    list_filter = (
        ('team', RelatedOnlyDropdownFilter),
        'rule',
    )
    raw_id_fields = ('team',)
    fields = ('team', 'rule')
