# Generated by Django 2.2.15 on 2020-12-09 17:07

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('users', '0005_permissionpreset'),
        ('courses', '0027_coursecategory_color_theme'),
    ]

    operations = [
        migrations.CreateModel(
            name='FirewallRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('slug', models.SlugField(max_length=255, unique=True, verbose_name='slug')),
                ('summary', models.CharField(blank=True, max_length=255, verbose_name='аннотация')),
            ],
            options={
                'verbose_name': 'Правило firewall',
                'verbose_name_plural': 'Правила firewall',
                'ordering': ('slug',),
            },
        ),
        migrations.CreateModel(
            name='TeamFirewallRule',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('team', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='team_firewall_rule', serialize=False, to='courses.CourseTeam', verbose_name='команда')),
                ('rule', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='teams', to='idm.FirewallRule', verbose_name='правило')),
            ],
            options={
                'verbose_name': 'Правило для команд',
                'verbose_name_plural': 'Правила для команд',
                'ordering': ('team',),
            },
        ),
        migrations.CreateModel(
            name='GroupFirewallRule',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='group_firewall_rule', serialize=False, to='users.Group', verbose_name='группа')),
                ('is_staff', models.BooleanField(default=False, verbose_name='Доступ в django-админку')),
                ('rule', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='groups', to='idm.FirewallRule', verbose_name='правило')),
            ],
            options={
                'verbose_name': 'Правило для групп',
                'verbose_name_plural': 'Правила для групп',
                'ordering': ('group',),
            },
        ),
    ]
