from django import forms
from django.forms.widgets import Select
from django.utils.translation import gettext_lazy as _

from .models import Mailing
from .settings import MailingTaskChoices


class MailingTaskSelectWidget(Select):
    _choices = None

    def tasks_as_choices(self):
        return (('', '---------'), ) + tuple(MailingTaskChoices.choices)

    @property
    def choices(self):
        if self._choices is None:
            self._choices = self.tasks_as_choices()
        return self._choices

    @choices.setter
    def choices(self, _):
        pass


class MailingTaskChoiceField(forms.ChoiceField):
    widget = MailingTaskSelectWidget

    def valid_value(self, value: str):
        return True


class MailingForm(forms.ModelForm):
    mailing_task = MailingTaskChoiceField(
        label=_("Задача по рассылке"),
        required=True,
    )

    class Meta:
        model = Mailing
        exclude = ()

    def clean(self):
        data = super().clean()
        if not data.get('mailing_task'):
            exc = forms.ValidationError(_("Нужно указать задачу по рассылке"))
            self._errors['mailing_task'] = self.error_class(exc.messages)
            raise exc

        return data
