# Generated by Django 3.0.11 on 2021-02-25 20:11

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0035_invalid_slugs'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseMailing',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('can_group_with_others', models.BooleanField(default=True, help_text='Разрешить группировать данную рассылку с другими курсами в одном письме.', verbose_name='группировать с другими курсами')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='mailings', to='courses.Course', verbose_name='курс')),
            ],
            options={
                'verbose_name': 'рассылка по курсу',
                'verbose_name_plural': 'рассылки по курсам',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Mailing',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('mailing_task', models.CharField(max_length=255, verbose_name='задача по рассылке')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('intended_for', models.CharField(choices=[('all', 'Все пользователи'), ('followers', 'Только подписчики'), ('students', 'Только студенты')], default='all', max_length=20, verbose_name='получатели')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
            ],
            options={
                'verbose_name': 'рассылка',
                'verbose_name_plural': 'рассылки',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='MailingEvent',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', model_utils.fields.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('recipients', django.contrib.postgres.fields.jsonb.JSONField(verbose_name='получатели')),
                ('parameters', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='параметры')),
                ('status', models.CharField(choices=[('pending', 'Ожидает'), ('processing', 'В обработке'), ('completed', 'Завершено'), ('cancelled', 'Отменено'), ('error', 'Ошибка')], default='pending', max_length=20, verbose_name='статус')),
                ('errors', models.TextField(blank=True, verbose_name='ошибки')),
                ('scheduled', models.DateTimeField(blank=True, null=True, verbose_name='запланировано')),
                ('completed', models.DateTimeField(blank=True, null=True, verbose_name='завершено')),
                ('course_mailings', models.ManyToManyField(blank=True, related_name='mailing_events', to='mailing.CourseMailing', verbose_name='рассылки по курсам')),
                ('mailing', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='events', to='mailing.Mailing', verbose_name='рассылка')),
            ],
            options={
                'verbose_name': 'событие в рассылке',
                'verbose_name_plural': 'события в рассылках',
                'ordering': ('-created',),
            },
        ),
        migrations.AddField(
            model_name='coursemailing',
            name='mailing',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='courses', to='mailing.Mailing', verbose_name='рассылка'),
        ),
        migrations.CreateModel(
            name='CourseFollower',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('inactive_by_user', models.BooleanField(default=False, verbose_name='отключено пользователем')),
                ('unsubscribed_date', models.DateTimeField(blank=True, null=True, verbose_name='дата отписки')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='followers', to='courses.Course', verbose_name='курс')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='course_follows', to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'подписчик курса',
                'verbose_name_plural': 'подписчики курсов',
                'ordering': ('-created',),
            },
        ),
    ]
