# Generated by Django 3.0.11 on 2021-03-16 15:19

from django.db import migrations
from django_celery_beat.models import (
    MINUTES
)

check_mailing_events_task_name = 'Check mailing events'
check_mailing_events_task_path = 'lms.mailing.tasks.check_mailing_events_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=MINUTES,
        every=10,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=check_mailing_events_task_name,
        defaults={
            'task': check_mailing_events_task_path,
            'interval': interval,
            'kwargs': {"time_limit": 30},
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=check_mailing_events_task_name,
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('mailing', '0003_mailin_event'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
