# Generated by Django 3.0.11 on 2021-04-02 00:45

from django.db import migrations
from django_celery_beat.models import (
    SECONDS
)
from django.conf import settings


mailing_course_enroll_begin_periodic_task_name = 'Mailing course enroll begin periodic task'
mailing_course_enroll_begin_periodic_task_path = 'lms.mailing.tasks.mailing_course_enroll_begin_periodic_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=SECONDS,
        every=settings.COURSE_ENROLL_BEGIN_CHECK_FREQUENCY,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=mailing_course_enroll_begin_periodic_task_name,
        defaults={
            'task': mailing_course_enroll_begin_periodic_task_path,
            'interval': interval,
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=mailing_course_enroll_begin_periodic_task_name,
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('mailing', '0004_check_mailing_event_task'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
