from import_export import resources
from import_export.fields import Field

from django.utils.translation import gettext_lazy as _

from .models import CourseFollower


class CourseFollowerResource(resources.ModelResource):
    fio = Field(attribute='user__staffprofile__full_name', column_name=_("ФИО"))
    username = Field(attribute='user__username', column_name=_("логин"))
    joined_at = Field(attribute='user__staffprofile__joined_at', column_name=_("дата выхода на работу"))
    is_head = Field(attribute='user__staffprofile__is_head', column_name=_("является ли руководителем"))
    staff_group1 = Field(column_name=_("группа 1"))
    staff_group2 = Field(column_name=_("группа 2"))
    staff_group3 = Field(column_name=_("группа 3"))
    staff_groups = Field(column_name=_("группы на стаффе"))
    course = Field(attribute='course__name', column_name=_("курс"))
    subscribed_date = Field(attribute='subscribed_date', column_name=_("дата подписки"))
    unsubscribed_date = Field(attribute='unsubscribed_date', column_name=_("дата отписки"))
    unsubscription_reason = Field(attribute='get_unsubscription_reason_display', column_name=_("причина отписки"))

    def dehydrate_staff_group1(self, course_follower: CourseFollower):
        return course_follower.user.staffprofile.groups_str(start=0, end=1)

    def dehydrate_staff_group2(self, course_follower: CourseFollower):
        return course_follower.user.staffprofile.groups_str(start=1, end=2)

    def dehydrate_staff_group3(self, course_follower: CourseFollower):
        return course_follower.user.staffprofile.groups_str(start=2, end=3)

    def dehydrate_staff_groups(self, course_follower: CourseFollower):
        return course_follower.user.staffprofile.groups_str(start=3)

    class Meta:
        model = CourseFollower
        fields = (
            'fio', 'username', 'joined_at', 'is_head', 'staff_group1', 'staff_group2', 'staff_group3', 'staff_groups',
            'course',
            'subscribed_date', 'unsubscribed_date', 'unsubscription_reason',
        )


class CourseFollowerHistoryResource(CourseFollowerResource):
    class Meta(CourseFollowerResource.Meta):
        model = CourseFollower.history.model
