from rest_framework import serializers

from lms.courses.models import Course

from .models import CourseFollower, CourseMailing, Mailing


# API
# --------------------------------------------------------------------------------
class MailingInlineListSerializer(serializers.ModelSerializer):
    class Meta:
        model = Mailing
        fields = (
            'id', 'name',
        )
        read_only_fields = fields


class CourseMailingListSerializer(serializers.ModelSerializer):
    mailing = MailingInlineListSerializer()

    """
    Список рассылок курса
    """
    class Meta:
        model = CourseMailing
        fields = (
            'course_id', 'mailing', 'is_active', 'created', 'modified',
        )
        read_only_fields = fields


class CourseInlineListSerializer(serializers.ModelSerializer):
    type = serializers.ChoiceField(choices=Course.TypeChoices.choices, source='course_type')

    class Meta:
        model = Course
        fields = (
            'id', 'name', 'type'
        )
        read_only_fields = fields


class MyCourseFollowsListSerializer(serializers.ModelSerializer):
    """
    Список курсов, на которые подписан пользователь
    """
    course = CourseInlineListSerializer()

    class Meta:
        model = CourseFollower
        fields = (
            'course',
        )
        read_only_fields = fields


class CourseFollowDetailSerializer(serializers.ModelSerializer):
    """
    Подписка пользователя на курс
    """
    course = CourseInlineListSerializer()

    class Meta:
        model = CourseFollower
        fields = (
            'course',
        )
        read_only_fields = fields


# LabAPI
# --------------------------------------------------------------------------------
class MailingListLabSerializer(serializers.ModelSerializer):
    """
    Список доступных рассылок
    """
    class Meta:
        model = Mailing
        fields = (
            'id', 'name', 'intended_for', 'is_active',
            'created', 'modified',
        )
        read_only_fields = fields


class CourseMailingListLabSerializer(serializers.ModelSerializer):
    """
    Список рассылок курса
    """
    class Meta:
        model = CourseMailing
        fields = (
            'mailing_id', 'is_active', 'can_group_with_others',
            'created', 'modified',
        )
        read_only_fields = fields


class CourseFollowerListLabSerializer(serializers.ModelSerializer):
    """
    Список подписчиков курса
    """
    class Meta:
        model = CourseFollower
        fields = (
            'user', 'is_active', 'subscribed_date', 'unsubscribed_date', 'subscribed_date',
            'created', 'modified',
        )
        read_only_fields = fields


class CourseMailingDetailLabSerializer(serializers.ModelSerializer):
    """
    Информация о рассылке курса
    """
    class Meta:
        model = CourseMailing
        fields = (
            'mailing_id', 'is_active', 'can_group_with_others',
            'created', 'modified',
        )
        read_only_fields = fields


class CourseMailingCreateLabSerializer(serializers.ModelSerializer):
    """
    Добавление рассылки в курс
    """
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(),
    )

    mailing_id = serializers.PrimaryKeyRelatedField(
        source='mailing', queryset=Mailing.objects.all(),
    )

    class Meta:
        model = CourseMailing
        fields = (
            'course_id', 'mailing_id',
            'is_active', 'can_group_with_others',
        )


class CourseMailingUpdateLabSerializer(serializers.ModelSerializer):
    """
    Изменение информации о рассылке курса
    """
    class Meta:
        model = CourseMailing
        fields = (
            'is_active', 'can_group_with_others',
        )
