from django.conf import settings
from django.db.models.enums import TextChoices
from django.utils.translation import gettext_lazy as _

MAILING_TASK_COURSE_ENROLL_BEGIN = 'mailing_course_enroll_begin_task'
MAILING_TASK_COURSE_NEW_FOLLOWER = 'mailing_course_new_follower_task'
MAILING_TASK_COURSE_AVAILABLE_AGAIN = 'mailing_course_available_again_task'

MAILING_TEMPLATES = getattr(settings, 'MAILING_TEMPLATES')


class MailingTaskChoices(TextChoices):
    COURSE_ENROLL_BEGIN = (
        MAILING_TASK_COURSE_ENROLL_BEGIN,
        _(f"Рассылка о начале регистрации на курс ({MAILING_TASK_COURSE_ENROLL_BEGIN})")
    )
    COURSE_NEW_FOLLOWER = (
        MAILING_TASK_COURSE_NEW_FOLLOWER,
        _(f"Рассылка для нового подписчика курса ({MAILING_TASK_COURSE_NEW_FOLLOWER})"),
    )
    COURSE_AVAILABLE_AGAIN = (
        MAILING_TASK_COURSE_AVAILABLE_AGAIN,
        _(f"Рассылка о наличие свободных мест на курсе ({MAILING_TASK_COURSE_AVAILABLE_AGAIN})"),
    )


MAILING_TASKS_CAMPAIGN_SLUGS_MAP = {
    mailing_task.value: MAILING_TEMPLATES.get(mailing_task.name, '')
    for mailing_task in MailingTaskChoices
}

MAILING_RECIPIENTS_CHUNK_SIZE = getattr(settings, 'MAILING_RECIPIENTS_CHUNK_SIZE')
