from django_admin_listfilter_dropdown.filters import RelatedOnlyDropdownFilter

from django.contrib import admin

from lms.core.admin.mixins import AddReadonlyFieldsMixin

from .models import Mentorship


@admin.register(Mentorship)
class MentorshipAdmin(AddReadonlyFieldsMixin, admin.ModelAdmin):
    search_fields = (
        'mentor__username', 'mentor__id', 'mentor__yauid',
        'mentee__username', 'mentee__id', 'mentee__yauid',
        'course__name', 'course__slug',
    )
    list_display = (
        'mentor', 'mentee', 'course', 'due_date', 'is_active', 'created_by',
        'created', 'modified',
    )
    list_select_related = ('mentor', 'mentee', 'created_by', 'course',)
    list_filter = (
        ('course', RelatedOnlyDropdownFilter),
        'is_active',
    )

    raw_id_fields = ('mentor', 'mentee', 'course')
    add_readonly_fields = ('created_by',)
    readonly_fields = ('created_by',)
    fields = (
        'mentor', 'mentee', 'course', 'due_date', 'is_active', 'created_by',
    )
