from django.contrib import admin

from .models import ModuleType


@admin.register(ModuleType)
class ModuleTypeAdmin(admin.ModelAdmin):
    list_display = ('name', 'app_label', 'model', 'is_active',)
    list_filter = ('is_active',)
    fields = ('app_label', 'model', 'model_class', 'is_active', 'model_doc')
    readonly_fields = ('app_label', 'model', 'model_class', 'model_doc')

    def model_doc(self, obj: ModuleType):
        return obj.model_class().__doc__

    def has_add_permission(self, request):
        return False

    def has_delete_permission(self, request, obj=None):
        return False
