from django.apps import AppConfig
from django.db.models.signals import post_migrate, pre_migrate
from django.utils.translation import gettext_lazy as _

from .management import create_module_types, inject_rename_moduletypes_operations


class ModuletypesConfig(AppConfig):
    name = 'lms.moduletypes'
    verbose_name = _("Типы модулей курсов")

    def ready(self):
        pre_migrate.connect(inject_rename_moduletypes_operations, sender=self)
        post_migrate.connect(create_module_types)
