from rest_framework import serializers

from .models import ModuleType


# API
# ===
class ModuleTypeDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = ModuleType
        fields = (
            'name', 'app_label', 'model',
        )
        read_only_fields = fields


# LabAPI
# ======
class ModuleTypeListLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = ModuleType
        fields = (
            'name', 'app_label', 'model', 'is_active',
        )
        read_only_fields = fields
