from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.viewsets import LabModelViewSet

from ..models import ModuleType
from ..serializers import ModuleTypeListLabSerializer


class ModuleTypeLabViewSet(LabModelViewSet):
    queryset = ModuleType.objects.all()
    serializer_class = ModuleTypeListLabSerializer
    pagination_class = None

    @extend_schema(
        summary=gettext("Список типов модулей")
    )
    def list(self, request, *args, **kwargs):
        return super().list(request, *args, **kwargs)
