from model_utils.models import TimeStampedModel
from ordered_model.models import OrderedModel, OrderedModelQuerySet

from django.db import models
from django.utils.translation import gettext_lazy as _

from lms.core.models.mixins import ActiveFilterMixin


class ColorThemeQuerySet(ActiveFilterMixin, OrderedModelQuerySet):
    pass


class ColorTheme(OrderedModel, TimeStampedModel):
    slug = models.SlugField(_("код"), unique=True, max_length=255)
    name = models.CharField(_("название"), max_length=255)
    is_active = models.BooleanField(_("активна"), default=True)

    course_card_gradient_color = models.CharField(_("цвет градиента карточки курса"), max_length=255, blank=True)

    objects = ColorThemeQuerySet.as_manager()

    class Meta:
        ordering = ('order',)
        verbose_name = _("цветовая схема")
        verbose_name_plural = _("цветовые схемы")

    def __str__(self):
        return self.name
