from rest_framework import serializers

from .models import ColorTheme


# API Serializers
# ===============
class ColorThemeListSerializer(serializers.ModelSerializer):
    class Meta:
        model = ColorTheme
        fields = (
            'id', 'slug', 'name',
            'course_card_gradient_color',
        )


class ColorThemeDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = ColorTheme
        fields = (
            'id', 'slug', 'name',
            'course_card_gradient_color',
        )


# LabAPI Serializers
# ==================
class ColorThemeListLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = ColorTheme
        fields = (
            'id', 'slug', 'name', 'is_active',
            'course_card_gradient_color',
            'created', 'modified',
        )
        read_only_fields = fields


class ColorThemeDetailLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = ColorTheme
        fields = (
            'id', 'slug', 'name', 'is_active',
            'course_card_gradient_color',
            'created', 'modified',
        )
        read_only_fields = fields
