from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.viewsets import LabModelViewSet

from ..models import ColorTheme
from ..serializers import ColorThemeListLabSerializer


class ColorThemeLabViewSet(LabModelViewSet):
    serializer_class = ColorThemeListLabSerializer
    queryset = ColorTheme.objects.active()
    pagination_class = None

    @extend_schema(
        summary=gettext("Список цветовых схем")
    )
    def list(self, request, *args, **kwargs):
        return super().list(request, *args, **kwargs)
