# Generated by Django 3.0.11 on 2021-06-15 06:44

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import lms.reports.models
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('courses', '0042_course_history'),
    ]

    operations = [
        migrations.CreateModel(
            name='ReportFile',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', model_utils.fields.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('report_type', models.CharField(choices=[('enrolled_users_report', 'отчет: список заявок на курс')], editable=False, max_length=255, verbose_name='тип отчета')),
                ('status', models.CharField(choices=[('created', 'создан'), ('completed', 'завершен'), ('error', 'ошибка')], default='created', max_length=16, verbose_name='статус операции')),
                ('error_message', models.TextField(blank=True, verbose_name='сообщение об ошибке')),
                ('file', models.FileField(blank=True, upload_to=lms.reports.models.ReportFile._content_upload_path, verbose_name='файл')),
            ],
            options={
                'verbose_name': 'файл с отчетом',
                'verbose_name_plural': 'файлы с отчетами',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='EnrolledUsersReport',
            fields=[
                ('reportfile_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='reports.ReportFile')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enrolled_users_reports', to='courses.Course', verbose_name='Курс')),
            ],
            options={
                'verbose_name': 'отчет: заявки на курс',
                'verbose_name_plural': 'отчеты: заявки на курс',
                'abstract': False,
            },
            bases=('reports.reportfile',),
        ),
    ]
