from django.db import transaction
from django.db.models import signals
from django.dispatch import receiver

from lms.reports.models import EnrolledUsersReport, StudentSlotsReport
from lms.reports.tasks import run_report_task


@receiver(signal=signals.post_save, sender=EnrolledUsersReport)
def enrolled_user_report_post_save_handler(instance: EnrolledUsersReport, **kwargs):
    if instance.status == EnrolledUsersReport.StatusChoices.CREATED:
        transaction.on_commit(lambda: run_report_task.delay(report_id=instance.id))


@receiver(signal=signals.post_save, sender=StudentSlotsReport)
def student_slots_report_post_save_handler(instance: StudentSlotsReport, **kwargs):
    if instance.status == StudentSlotsReport.StatusChoices.CREATED:
        transaction.on_commit(lambda: run_report_task.delay(report_id=instance.id))
