from rest_framework import serializers

from .models import EnrolledUsersReport, ReportFile, StudentSlotsReport


class ReportFileDetailLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = ReportFile
        fields = (
            'id', 'status', 'error_message', 'file',
        )
        read_only_fields = fields


class EnrolledUsersReportDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = EnrolledUsersReport
        fields = (
            'id', 'status', 'error_message', 'file', 'course',
        )
        read_only_fields = fields


class StudentSlotsReportDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = StudentSlotsReport
        fields = (
            'id', 'status', 'error_message', 'file', 'course',
        )
        read_only_fields = fields
