from django_admin_listfilter_dropdown.filters import RelatedOnlyDropdownFilter

from django.contrib import admin

from .models import LinkResource, TextResource, VideoResource


@admin.register(TextResource)
class TextResourceAdmin(admin.ModelAdmin):
    list_display = ('name', 'course', 'is_active', 'created', 'modified')
    list_select_related = ('course',)
    list_filter = (
        ('course', RelatedOnlyDropdownFilter),
    )
    raw_id_fields = ('course',)


@admin.register(LinkResource)
class LinkResourceAdmin(admin.ModelAdmin):
    list_display = ('name', 'course', 'is_active', 'created', 'modified')
    list_select_related = ('course',)
    list_filter = (
        ('course', RelatedOnlyDropdownFilter),
    )
    raw_id_fields = ('course',)


@admin.register(VideoResource)
class VideoResourceAdmin(admin.ModelAdmin):
    list_display = ('name', 'course', 'is_active', 'created', 'modified')
    list_select_related = ('course',)
    list_filter = (
        ('course', RelatedOnlyDropdownFilter),
    )
    raw_id_fields = ('course',)
    fields = ('course', 'block', 'name', 'description', 'url', 'is_active', 'weight', 'estimated_time')
    search_fields = ('course__id', 'course__slug', 'course__name', 'name', 'url')
