from django.db import models
from django.utils.translation import gettext_lazy as _

from lms.courses.models import CourseModule


class TextResource(CourseModule):
    """
    Модуль Текст
    """
    content = models.TextField(_("содержимое"), blank=True)

    class Meta:
        verbose_name = _("Текст")
        verbose_name_plural = _("Текст")


class LinkResource(CourseModule):
    """
    Модуль Ссылка
    """
    url = models.URLField(_("ссылка"))

    class Meta:
        verbose_name = _("Ссылка")
        verbose_name_plural = _("Ссылки")


class VideoResource(CourseModule):
    """
    Видео
    """
    url = models.URLField(_("ссылка на видео"), max_length=500)

    class Meta:
        verbose_name = _('Видео')
        verbose_name_plural = _('Видео')
