from rest_framework import serializers

from lms.courses.serializers import (
    CourseModuleCreateBaseSerializer, CourseModuleDetailBaseSerializer, CourseModuleUpdateBaseSerializer,
)

from .models import LinkResource, TextResource, VideoResource


# API
# ===
class TextResourceDetailSerializer(serializers.ModelSerializer):
    """
    Информация по модулю Текст
    """

    class Meta:
        model = TextResource
        fields = (
            'id', 'name', 'description', 'content', 'estimated_time',
        )
        read_only_fields = fields


class LinkResourceDetailSerializer(serializers.ModelSerializer):
    """
    Информация по модулю Ссылка
    """

    class Meta:
        model = LinkResource
        fields = (
            'id', 'name', 'description', 'url', 'estimated_time',
        )
        read_only_fields = fields


class VideoResourceDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = VideoResource
        fields = (
            'id', 'name', 'description', 'url', 'estimated_time',
        )
        read_only_fields = fields


# LabAPI
# ======
class TextResourceDetailLabSerializer(CourseModuleDetailBaseSerializer):
    """
    Информация по модулю Текст
    """

    class Meta(CourseModuleDetailBaseSerializer.Meta):
        model = TextResource
        fields = CourseModuleDetailBaseSerializer.Meta.fields + (
            'content',
        )
        read_only_fields = fields


class TextResourceCreateLabSerializer(CourseModuleCreateBaseSerializer):
    """
    Создание модуля Текст
    """

    class Meta(CourseModuleCreateBaseSerializer.Meta):
        model = TextResource
        fields = CourseModuleCreateBaseSerializer.Meta.fields + (
            'content', 'estimated_time',
        )


class TextResourceUpdateLabSerializer(CourseModuleUpdateBaseSerializer):
    """
    Обновление модуля Текст
    """

    class Meta(CourseModuleUpdateBaseSerializer.Meta):
        model = TextResource
        fields = CourseModuleUpdateBaseSerializer.Meta.fields + (
            'content', 'estimated_time',
        )


class LinkResourceDetailLabSerializer(CourseModuleDetailBaseSerializer):
    """
    Информация по модулю Ссылка
    """

    class Meta(CourseModuleDetailBaseSerializer.Meta):
        model = LinkResource
        fields = CourseModuleDetailBaseSerializer.Meta.fields + (
            'url',
        )
        read_only_fields = fields


class LinkResourceCreateLabSerializer(CourseModuleCreateBaseSerializer):
    """
    Создание модуля Ссылка
    """

    class Meta(CourseModuleCreateBaseSerializer.Meta):
        model = LinkResource
        fields = CourseModuleCreateBaseSerializer.Meta.fields + (
            'url', 'estimated_time',
        )


class LinkResourceUpdateLabSerializer(CourseModuleUpdateBaseSerializer):
    """
    Обновление модуля Ссылка
    """

    class Meta(CourseModuleUpdateBaseSerializer.Meta):
        model = LinkResource
        fields = CourseModuleUpdateBaseSerializer.Meta.fields + (
            'url', 'estimated_time',
        )


class VideoResourceDetailLabSerializer(CourseModuleDetailBaseSerializer):
    """
    Просмотр модуля Видео
    """
    class Meta(CourseModuleDetailBaseSerializer.Meta):
        model = VideoResource
        fields = CourseModuleDetailBaseSerializer.Meta.fields + (
            'url',
        )
        read_only_fields = fields


class VideoResourceCreateLabSerializer(CourseModuleCreateBaseSerializer):
    """
    Создание модуля Видео
    """
    class Meta(CourseModuleCreateBaseSerializer.Meta):
        model = VideoResource
        fields = CourseModuleCreateBaseSerializer.Meta.fields + (
            'url', 'estimated_time',
        )


class VideoResourceUpdateLabSerializer(CourseModuleUpdateBaseSerializer):
    """
    Обновление модуля Видео
    """
    class Meta(CourseModuleUpdateBaseSerializer.Meta):
        model = VideoResource
        fields = CourseModuleUpdateBaseSerializer.Meta.fields + (
            'url', 'estimated_time',
        )
