from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.courses.views.api import CourseModuleBaseViewSet

from ..models import LinkResource, TextResource, VideoResource
from ..serializers import LinkResourceDetailSerializer, TextResourceDetailSerializer, VideoResourceDetailSerializer


class TextResourceViewSet(CourseModuleBaseViewSet):
    """
    Модуль Текст
    """
    serializer_class = TextResourceDetailSerializer
    queryset = TextResource.objects.active()
    pagination_class = None

    @extend_schema(
        summary=gettext("Информация о модуле Текст")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)


class LinkResourceViewSet(CourseModuleBaseViewSet):
    """
    Модуль Ссылка
    """
    serializer_class = LinkResourceDetailSerializer
    queryset = LinkResource.objects.active()
    pagination_class = None

    @extend_schema(
        summary=gettext("Информация о модуле Ссылка")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)


class VideoResourceViewSet(CourseModuleBaseViewSet):
    """
    Модуль Видео
    """
    serializer_class = VideoResourceDetailSerializer
    queryset = VideoResource.objects.active()
    pagination_class = None

    @extend_schema(
        summary=gettext("Информация о модуле Видео")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)
