from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.pagination import LimitOffsetAllPagination
from lms.core.views.viewsets import LabModelViewSet
from lms.courses.permissions import CourseObjectPermission
from lms.courses.views import GetCourseMixin

from ..models import LinkResource, TextResource, VideoResource
from ..serializers import (
    LinkResourceCreateLabSerializer, LinkResourceDetailLabSerializer, LinkResourceUpdateLabSerializer,
    TextResourceCreateLabSerializer, TextResourceDetailLabSerializer, TextResourceUpdateLabSerializer,
    VideoResourceCreateLabSerializer, VideoResourceDetailLabSerializer, VideoResourceUpdateLabSerializer,
)


class TextResourceLabViewSet(GetCourseMixin, LabModelViewSet):
    """
    Модуль Текст
    """
    serializer_class = TextResourceDetailLabSerializer
    serializer_classes = {
        'create': TextResourceCreateLabSerializer,
        'update': TextResourceUpdateLabSerializer,
        'partial_update': TextResourceUpdateLabSerializer,
        'retrieve': TextResourceDetailLabSerializer,
    }
    queryset = TextResource.objects.select_related('course')
    pagination_class = LimitOffsetAllPagination
    permission_classes = LabModelViewSet.permission_classes + [CourseObjectPermission]

    @extend_schema(
        responses={200: TextResourceDetailLabSerializer},
        summary=gettext("Информация по модулю Текст")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)

    @extend_schema(
        request=TextResourceCreateLabSerializer,
        responses={201: TextResourceDetailLabSerializer},
        summary=gettext("Создание модуля Текст"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    @extend_schema(
        request=TextResourceUpdateLabSerializer,
        responses={200: TextResourceDetailLabSerializer},
        summary=gettext("Обновление модуля Текст"),
    )
    def update(self, request, *args, **kwargs):
        return super().update(request, *args, **kwargs)

    @extend_schema(
        request=TextResourceUpdateLabSerializer,
        responses={200: TextResourceDetailLabSerializer},
        summary=gettext("Частичное обновление модуля Текст"),
    )
    def partial_update(self, request, *args, **kwargs):
        return super().partial_update(request, *args, **kwargs)

    @extend_schema(
        summary=gettext("Удаление модуля Текст"),
    )
    def destroy(self, request, *args, **kwargs):
        return super().destroy(request, *args, **kwargs)


class LinkResourceLabViewSet(GetCourseMixin, LabModelViewSet):
    """
    Модуль Ссылка
    """
    serializer_class = LinkResourceDetailLabSerializer
    serializer_classes = {
        'create': LinkResourceCreateLabSerializer,
        'update': LinkResourceUpdateLabSerializer,
        'partial_update': LinkResourceUpdateLabSerializer,
        'retrieve': LinkResourceDetailLabSerializer,
    }
    queryset = LinkResource.objects.select_related('course')
    pagination_class = LimitOffsetAllPagination
    permission_classes = LabModelViewSet.permission_classes + [CourseObjectPermission]

    @extend_schema(
        responses={200: LinkResourceDetailLabSerializer},
        summary=gettext("Информация по модулю Ссылка")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)

    @extend_schema(
        request=LinkResourceCreateLabSerializer,
        responses={201: LinkResourceDetailLabSerializer},
        summary=gettext("Создание модуля Ссылка"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    @extend_schema(
        request=LinkResourceUpdateLabSerializer,
        responses={200: LinkResourceDetailLabSerializer},
        summary=gettext("Обновление модуля Ссылка"),
    )
    def update(self, request, *args, **kwargs):
        return super().update(request, *args, **kwargs)

    @extend_schema(
        request=LinkResourceUpdateLabSerializer,
        responses={200: LinkResourceDetailLabSerializer},
        summary=gettext("Частичное обновление модуля Ссылка"),
    )
    def partial_update(self, request, *args, **kwargs):
        return super().partial_update(request, *args, **kwargs)

    @extend_schema(
        summary=gettext("Удаление модуля Ссылка"),
    )
    def destroy(self, request, *args, **kwargs):
        return super().destroy(request, *args, **kwargs)


class VideoResourceLabViewSet(GetCourseMixin, LabModelViewSet):
    """
    Модуль Видео
    """
    serializer_class = VideoResourceDetailLabSerializer
    serializer_classes = {
        'create': VideoResourceCreateLabSerializer,
        'update': VideoResourceUpdateLabSerializer,
        'partial_update': VideoResourceUpdateLabSerializer,
        'retrieve': VideoResourceDetailLabSerializer,
    }
    queryset = VideoResource.objects.select_related('course')
    pagination_class = LimitOffsetAllPagination
    permission_classes = LabModelViewSet.permission_classes + [CourseObjectPermission]

    @extend_schema(
        responses={200: VideoResourceDetailLabSerializer},
        summary=gettext("Информация по модулю Видео")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)

    @extend_schema(
        request=VideoResourceCreateLabSerializer,
        responses={201: VideoResourceDetailLabSerializer},
        summary=gettext("Создание модуля Видео"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    @extend_schema(
        request=VideoResourceUpdateLabSerializer,
        responses={200: VideoResourceDetailLabSerializer},
        summary=gettext("Обновление модуля Видео"),
    )
    def update(self, request, *args, **kwargs):
        return super().update(request, *args, **kwargs)

    @extend_schema(
        request=VideoResourceUpdateLabSerializer,
        responses={200: VideoResourceDetailLabSerializer},
        summary=gettext("Частичное обновление модуля Видео"),
    )
    def partial_update(self, request, *args, **kwargs):
        return super().partial_update(request, *args, **kwargs)

    @extend_schema(
        summary=gettext("Удаление модуля Видео"),
    )
    def destroy(self, request, *args, **kwargs):
        return super().destroy(request, *args, **kwargs)
