DEFAULT_INIT_STATE = {
    '_version': '1484.11',  # Версия LMS-модели из документации
    'comments_from_learner': {
        '_children': '',
        '_count': 0,
    },
    'comments_from_lms': {
        '_children': '',
        '_count': 0,
    },
    # (“completed”, “incomplete”, “not attempted”, “unknown”, RW) Indicates whether the learner has completed the SCO
    'completion_status': '',
    # (real(10,7) range (0..1), RO) Used to determine whether the SCO should be considered complete
    'completion_threshold': 0,
    # (“credit”, “no-credit”, RO) Indicates whether the learner will be credited for performance in the SCO
    'credit': '',
    'entry': '',  # (ab_initio, resume, “”, RO) Asserts whether the learner has previously accessed the SCO
    'exit': '',  # (timeout, suspend, logout, normal, “”, WO) Indicates how or why the learner left the SCO
    'interactions': {
        '_children': '',
        '_count': 0,
    },
    # (characterstring (SPM: 4000), RO) Data provided to a SCO after launch,
    # initialized from the dataFromLMS manifest element
    'launch_data': '',
    # (long_identifier_type (SPM: 4000), RO) Identifies the learner on behalf of whom the SCO was launched
    'learner_id': '',
    'learner_name': '',  # (localized_string_type (SPM: 250), RO) Name provided for the learner by the LMS
    'learner_preference': {
        # (audio_level,language,delivery_speed,audio_captioning, RO) Listing of supported data model elements
        '_children': 'audio_level,language,delivery_speed,audio_captioning',
        'audio_level': 0,  # (real(10,7), range (0..*), RW) Specifies an intended change in perceived audio level
        # (language_type (SPM 250), RW) The learner’s preferred language for SCOs with multilingual capability
        'language': '',
        # (real(10,7), range (0..*), RW) The learner’s preferred relative speed of content delivery
        'delivery_speed': 0,
        # (“-1”, “0”, “1”, RW) Specifies whether captioning text corresponding to audio is displayed
        'audio_captioning': 0,
    },
    'location': '',  # (characterstring (SPM: 1000), RW) The learner’s current location in the SCO
    # (timeinterval (second,10,2), RO) Amount of accumulated time the learner is allowed to use a SCO
    'max_time_allowed': '',
    # (“browse”, “normal”, “review”, RO)
    # Identifies one of three possible modes in which the SCO may be presented to the learner
    'mode': '',
    'objectives': {
        '_children': {},
        '_count': 0,
    },
    # (real (10,7) range (0..1), RW) Measure of the progress the learner has made toward completing the SCO
    'progress_measure': 0,
    'scaled_passing_score': 0,  # (real(10,7) range (-1 .. 1), RO) Scaled passing score required to master the SCO
    'score': {
        '_children': 'scaled,raw,min,max',  # (scaled,raw,min,max, RO) Listing of supported data model elements
        'scaled': 0,  # (real (10,7) range (-1..1), RW) Number that reflects the performance of the learner
        # (real (10,7), RW) Number that reflects the performance of the learner relative to the range
        # bounded by the values of min and max
        'raw': 0,
        'min': 0,  # (real (10,7), RW) Minimum value in the range for the raw score
        'max': 0,  # (real (10,7), RW) Maximum value in the range for the raw score
    },
    # (timeinterval (second,10,2), WO)
    # Amount of time that the learner has spent in the current learner session for this SCO
    'session_time': 0,
    'success_status': 0,  # (“passed”, “failed”, “unknown”, RW) Indicates whether the learner has mastered the SCO
    # (characterstring (SPM: 64000), RW) Provides space to store and retrieve data between learner sessions
    'suspend_data': '',
    # (“exit,message”, “continue,message”, “exit,no message”, “continue,no message”, RO)
    # Indicates what the SCO should do when cmi.max_time_allowed is exceeded
    'time_limit_action': '',
    # (timeinterval (second,10,2), RO)
    # Sum of all of the learner’s session times accumulated in the current learner attempt
    'total_time': 0,
}
