LEAF_ITEM_SCHEMA_NAME = "leaf_item_schema"
LEAF_ITEM_SCHEMA = {
    "type": "object",
    "properties": {
        "@identifier": {
            "type": "string",
        },
        "@identifierref": {
            "type": "string",
        },
        "title": {
            "type": "string",
        },
    },
    "required": ["@identifier", "@identifierref", "title"],
}

NODE_ITEM_SCHEMA_NAME = "node_item_schema"
NODE_ITEM_SCHEMA = {
    "oneOf": [
        {
            "type": "object",
            "properties": {
                "item": {"$ref": f"#/definitions/{LEAF_ITEM_SCHEMA_NAME}"},
            },
            "required": ["item"],
        },
        {
            "type": "object",
            "properties": {
                "items": {
                    "type": "array",
                    "items": {"$ref": f"#/definitions/{NODE_ITEM_SCHEMA_NAME}"},
                },
            },
            "required": ["items"],
        }
    ],
}

ITEM_SCHEMA_NAME = "item_schema"
ITEM_SCHEMA = {
    "oneOf": [
        {"$ref": f"#/definitions/{NODE_ITEM_SCHEMA_NAME}"},
        {"$ref": f"#/definitions/{LEAF_ITEM_SCHEMA_NAME}"},
    ],
}

ORGANIZATION_SCHEMA_NAME = "organization_schema"
ORGANIZATION_SCHEMA = {
    "allOf": [
        {
            "type": "object",
            "properties": {
                "@identifier": {
                    "type": "string",
                },
                "title": {
                    "type": "string",
                },
            },
            "required": ["@identifier", "title"],
        },
        {"$ref": f"#/definitions/{NODE_ITEM_SCHEMA_NAME}"},
    ],
}

ORGANIZATIONS_SCHEMA_NAME = "organizations_schema"
ORGANIZATIONS_SCHEMA = {
    "type": "object",
    "properties": {
        "@default": {
            "type": "string",
        },
        "organization": {
            "type": "array",
            "items": {
                "$ref": f"#/definitions/{ORGANIZATION_SCHEMA_NAME}",
            },
        }
    },
    "required": ["@default", "organization"],

}

ASSET_RESOURCE_SCHEMA = {
    "type": "object",
    "properties": {
        "@identifier": {
            "type": "string",
        },
        "@type": {
            "type": "string",
            "enum": ["webcontent"],
        },
        "@adlcp:scormType": {
            "type": "string",
            "enum": ["sco", "asset"],
            "const": "asset",
        },
    },
    "required": ["@identifier", "@type", "@adlcp:scormType"],
}

SCO_RESOURCE_SCHEMA = {
    "type": "object",
    "properties": {
        "@identifier": {
            "type": "string",
        },
        "@type": {
            "type": "string",
            "enum": ["webcontent"],
        },
        "@adlcp:scormType": {
            "type": "string",
            "const": "sco",
        },
        "@href": {
            "type": "string",
        },
    },
    "required": ["@identifier", "@type", "@href"],
}

RESOURCE_SCHEMA_NAME = "resource_schema"
RESOURCE_SCHEMA = {
    "anyOf": [
        ASSET_RESOURCE_SCHEMA,
        SCO_RESOURCE_SCHEMA,
    ]
}

RESOURCES_SCHEMA_NAME = "resources_schema"
RESOURCES_SCHEMA = {
    "type": "object",
    "properties": {
        "resource": {
            "type": "array",
            "items": {"$ref": f"#/definitions/{RESOURCE_SCHEMA_NAME}"},
        },
    },
    "required": ["resource"],
}

MANIFEST_SCHEMA = {
    "definitions": {
        RESOURCE_SCHEMA_NAME: RESOURCE_SCHEMA,
        RESOURCES_SCHEMA_NAME: RESOURCES_SCHEMA,
        LEAF_ITEM_SCHEMA_NAME: LEAF_ITEM_SCHEMA,
        NODE_ITEM_SCHEMA_NAME: NODE_ITEM_SCHEMA,
        ITEM_SCHEMA_NAME: ITEM_SCHEMA,
        ORGANIZATION_SCHEMA_NAME: ORGANIZATION_SCHEMA,
        ORGANIZATIONS_SCHEMA_NAME: ORGANIZATIONS_SCHEMA,
    },
    "type": "object",
    "properties": {
        "manifest": {
            "type": "object",
            "properties": {
                "organizations": {"$ref": f"#/definitions/{ORGANIZATIONS_SCHEMA_NAME}"},
                "resources": {"$ref": f"#/definitions/{RESOURCES_SCHEMA_NAME}"},
            },
            "required": ["organizations", "resources"],
        }
    },
    "required": ["manifest"],
}
