# Generated by Django 3.0.11 on 2021-02-16 17:34

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('courses', '0035_invalid_slugs'),
    ]

    operations = [
        migrations.CreateModel(
            name='Scorm',
            fields=[
                ('coursemodule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='courses.CourseModule')),
                ('source_url', models.FileField(blank=True, help_text='путь к загруженному архиву со scorm-курсом', max_length=255, upload_to='lms/scorm/zip/%Y-%m-%d-%H-%M-%S/', verbose_name='архив с курсом')),
                ('public_url', models.CharField(blank=True, help_text='путь к папке с распакованным scorm-курсом', max_length=255, verbose_name='распакованный курс')),
                ('status', models.CharField(choices=[('pending', 'в обработке'), ('ready', 'готов'), ('error', 'ошибка')], default='pending', help_text='статус распаковки архива с курсом и готовности к использованию', max_length=10, verbose_name='статус')),
                ('error_messages', models.TextField(blank=True, verbose_name='ошибки распаковки архива и разбора манифеста')),
                ('manifest', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='разобранный xml-манифест scorm-курса (imsmanifest.xml)', verbose_name='манифест')),
                ('max_attempts', models.PositiveSmallIntegerField(help_text='максимальное количество попыток прохождения scorm-курса студентом (0 - неограничено)', verbose_name='максимальное количество попыток', default=1)),
            ],
            options={
                'verbose_name': 'SCORM',
                'verbose_name_plural': 'SCORM',
                'ordering': ('order',),
            },
            bases=('courses.coursemodule',),
        ),
        migrations.CreateModel(
            name='ScormResource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('resource_id', models.CharField(max_length=255, verbose_name='идентификатор ресурса')),
                ('href', models.CharField(help_text='относительный путь к точке входа в ресурс в папке со scorm-курсом', max_length=255, verbose_name='путь к ресурсу')),
                ('scorm', models.ForeignKey(help_text='scorm-курс, к которому относится данный ресурс', on_delete=django.db.models.deletion.CASCADE, related_name='resources', to='scorm.Scorm', verbose_name='scorm-курс')),
            ],
            options={
                'verbose_name': 'SCORM-ресурс',
                'verbose_name_plural': 'SCORM-ресурсы',
                'unique_together': {('scorm', 'resource_id')},
            },
        ),
    ]
