# Generated by Django 3.0.11 on 2021-02-24 16:38

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0035_invalid_slugs'),
        ('scorm', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalScormStudentAttempt',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('current_attempt', models.PositiveSmallIntegerField(default=1, verbose_name='номер текущей попытки')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('scorm', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='scorm.Scorm', verbose_name='scorm-курс')),
                ('student', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'historical Попытка прохождения Scorm-курса',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='ScormStudentAttempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('current_attempt', models.PositiveSmallIntegerField(default=1, verbose_name='номер текущей попытки')),
                ('scorm', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='students_attempts', to='scorm.Scorm', verbose_name='scorm-курс')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='scorm_attempts', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'Попытка прохождения Scorm-курса',
                'verbose_name_plural': 'Попытки прохождения Scorm-курса',
                'unique_together': {('scorm', 'student')},
            },
        ),
        migrations.CreateModel(
            name='ScormResourceStudentAttempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('current_attempt', models.PositiveSmallIntegerField(default=1, verbose_name='номер текущей попытки')),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='данные прохождения пользователем scorm-ресурса', verbose_name='данные прохождения')),
                ('scorm_resource', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='students_resource_attempts', to='scorm.ScormResource', verbose_name='scorm-ресурс')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='student_scorm_resource_attempts', to='courses.CourseStudent', verbose_name='попытка прохождения scorm-курса')),
            ],
            options={
                'verbose_name': 'Попытка прохождения Scorm-ресурса',
                'verbose_name_plural': 'Попытки прохождения Scorm-ресурса',
                'unique_together': {('student', 'scorm_resource', 'current_attempt')},
            },
        ),
    ]
