# Generated by Django 3.0.11 on 2021-10-25 15:06

from django.db import migrations, models
import django.db.models.deletion


def forward(apps, schema_editor):
    CourseFile = apps.get_model('courses', 'CourseFile')
    Scorm = apps.get_model('scorm', 'Scorm')
    scorms_with_source_url = (
        Scorm.objects
        .exclude(source_url__isnull=True)
        .exclude(source_url__exact='')
        .select_related()
    )
    for scorm in scorms_with_source_url:
        course_file = CourseFile(
            course=scorm.course,
            url=scorm.source_url,
            status='success',
        )
        course_file.save()
        scorm.course_file = course_file
        scorm.save(update_fields=['course_file'])


def backward(apps, schema_editor):
    Scorm = apps.get_model('scorm', 'Scorm')
    CourseFile = apps.get_model('courses', 'CourseFile')
    scorms = Scorm.objects.exclude(course_file__isnull=True)
    scorm_course_file_ids = []
    for scorm in scorms:
        scorm.source_url = scorm.course_file.url
        scorm.save(update_fields=['source_url'])
        scorm_course_file_ids.append(scorm.course_file.id)

    CourseFile.objects.filter(id__in=scorm_course_file_ids).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0052_coursefile_path_and_status'),
        ('scorm', '0002_historicalscormstudentattempt_scormresourcestudentattempt_scormstudentattempt'),
    ]

    operations = [
        migrations.AddField(
            model_name='scorm',
            name='course_file',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='scorm_modules', to='courses.CourseFile', verbose_name='файл курса'),
        ),
        migrations.RunPython(forward, backward),
        migrations.RemoveField(
            model_name='scorm',
            name='source_url',
        ),
    ]
