# Generated by Django 3.0.14 on 2022-04-07 17:51

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0065_coursefile_file'),
        ('scorm', '0006_delete_scorm_models'),
    ]

    operations = [
        migrations.CreateModel(
            name='Scorm',
            fields=[
                ('coursemodule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='courses.CourseModule')),
            ],
            options={
                'verbose_name': 'SCORM',
                'verbose_name_plural': 'SCORM',
                'ordering': ('order',),
            },
            bases=('courses.coursemodule',),
        ),
        migrations.CreateModel(
            name='ScormFile',
            fields=[
                ('coursefile_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='courses.CourseFile')),
                ('public_url', models.CharField(blank=True, help_text='путь к папке с распакованным scorm-курсом', max_length=255, verbose_name='распакованный курс')),
                ('scorm_status', models.CharField(choices=[('pending', 'в обработке'), ('ready', 'готов'), ('error', 'ошибка')], default='pending', help_text='статус распаковки архива с курсом и готовности к использованию', max_length=10, verbose_name='статус')),
                ('error_messages', models.TextField(blank=True, verbose_name='ошибки распаковки архива и разбора манифеста')),
                ('manifest', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='разобранный xml-манифест scorm-курса (imsmanifest.xml)', verbose_name='манифест')),
                ('max_attempts', models.PositiveSmallIntegerField(default=1, help_text='максимальное количество попыток прохождения scorm-курса студентом (0 - неограничено)', verbose_name='максимальное количество попыток')),
                ('scorm', models.ForeignKey(help_text='scorm-курс, к которому относится данный файл', on_delete=django.db.models.deletion.CASCADE, related_name='files', to='scorm.Scorm', verbose_name='scorm')),
            ],
            options={
                'verbose_name': 'SCORM файл',
                'verbose_name_plural': 'SCORM файлы',
            },
            bases=('courses.coursefile',),
        ),
        migrations.CreateModel(
            name='ScormResource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('resource_id', models.CharField(max_length=255, verbose_name='идентификатор ресурса')),
                ('href', models.CharField(help_text='относительный путь к точке входа в ресурс в папке со scorm-курсом', max_length=255, verbose_name='путь к ресурсу')),
                ('scorm_file', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='resources', to='scorm.ScormFile', verbose_name='scorm-файл')),
            ],
            options={
                'verbose_name': 'SCORM-ресурс',
                'verbose_name_plural': 'SCORM-ресурсы',
                'unique_together': {('scorm_file', 'resource_id')},
            },
        ),
        migrations.AddField(
            model_name='scorm',
            name='current_file',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='scorm_module', to='scorm.ScormFile', verbose_name='текущая версия файла'),
        ),
        migrations.CreateModel(
            name='HistoricalScormStudentAttempt',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('current_attempt', models.PositiveSmallIntegerField(default=1, verbose_name='номер текущей попытки')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('scorm', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='scorm.Scorm', verbose_name='scorm-курс')),
                ('scorm_file', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='scorm.ScormFile', verbose_name='scorm-файл')),
                ('student', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'historical Попытка прохождения Scorm-курса',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='ScormStudentAttempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('current_attempt', models.PositiveSmallIntegerField(default=1, verbose_name='номер текущей попытки')),
                ('scorm', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='students_attempts', to='scorm.Scorm', verbose_name='scorm-курс')),
                ('scorm_file', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='scorm.ScormFile', verbose_name='scorm-файл')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='scorm_attempts', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'Попытка прохождения Scorm-курса',
                'verbose_name_plural': 'Попытки прохождения Scorm-курса',
                'unique_together': {('scorm', 'student')},
            },
        ),
        migrations.CreateModel(
            name='ScormResourceStudentAttempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('current_attempt', models.PositiveSmallIntegerField(default=1, verbose_name='номер текущей попытки')),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='данные прохождения пользователем scorm-ресурса', verbose_name='данные прохождения')),
                ('scaled_score', models.DecimalField(blank=True, decimal_places=7, help_text='Балл студента в диапазоне -1.0...1.0', max_digits=10, null=True, verbose_name='Балл, набранный студентом')),
                ('scorm_resource', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='students_resource_attempts', to='scorm.ScormResource', verbose_name='scorm-ресурс')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='student_scorm_resource_attempts', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'Попытка прохождения Scorm-ресурса',
                'verbose_name_plural': 'Попытки прохождения Scorm-ресурса',
                'unique_together': {('student', 'scorm_resource', 'current_attempt')},
            },
        ),
    ]
