from typing import TYPE_CHECKING

from django.core.exceptions import NON_FIELD_ERRORS, ValidationError
from django.utils.translation import gettext_lazy as _

from lms.courses.models import CourseStudent

if TYPE_CHECKING:
    from .models import Scorm, ScormResource, ScormStudentAttempt


def validate_student_scorm_course(scorm: 'Scorm', student: CourseStudent) -> None:
    if scorm.course_id != student.course_id:
        raise ValidationError({
            'student': ValidationError(_("курс студента не совпадает с курсом модуля"), code='invalid'),
        })


def validate_scorm_max_attempts(attempt: 'ScormStudentAttempt') -> None:
    if attempt.scorm.max_attempts != 0 and attempt.current_attempt > attempt.scorm.max_attempts:
        raise ValidationError({
            NON_FIELD_ERRORS: ValidationError(_("превышено максимальное количество попыток"), code='invalid')
        })


def validate_student_resource_attempt_course(student: CourseStudent, scorm_resource: 'ScormResource') -> None:
    if student.course_id != scorm_resource.scorm_file.scorm.course_id:
        raise ValidationError({
            'student': ValidationError(_("курс студента не совпадает с курсом scorm-ресурса"), code='invalid'),
        })
