from django.core.management.base import BaseCommand

from lms.staff.services import load_staff_groups


class Command(BaseCommand):
    help = "Loads all groups/departments from Staff"

    def add_arguments(self, parser):
        parser.add_argument(
            '--limit', dest='limit', type=int,
            help='Limit per Staff API request',
        )
        parser.add_argument(
            '--max-limit', dest='max_limit', type=int,
            help='Max limit of results'
        )

    def handle(self, *args, **options):
        load_staff_groups(**options)
        self.stdout.write("Done\n")
