from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand

from lms.staff.services import load_staff_profile_groups

User = get_user_model()


class Command(BaseCommand):
    help = "Load department list for every user in database from Staff"

    def add_arguments(self, parser):
        parser.add_argument(
            '--limit', dest='limit', type=int,
            help='Limit per Staff API request',
        )
        parser.add_argument(
            '--max-limit', dest='max_limit', type=int,
            help='Max limit of results'
        )

    def handle(self, *args, **options):
        uids = User.objects.filter(staffprofile__isnull=False).values_list('yauid', flat=True)
        uids = list(uids)

        load_staff_profile_groups(uids, limit=options['limit'], max_limit=options['max_limit'])

        self.stdout.write("Done\n")
