# Generated by Django 2.2.13 on 2020-07-23 00:51

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='StaffCity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name_ru', models.CharField(max_length=255, verbose_name='название RU')),
                ('name_en', models.CharField(blank=True, max_length=255, verbose_name='название EN')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
            ],
            options={
                'verbose_name': 'город на Стаффе',
                'verbose_name_plural': 'города',
            },
        ),
        migrations.CreateModel(
            name='StaffCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('code', models.CharField(max_length=20, verbose_name='код')),
                ('name_ru', models.CharField(max_length=255, verbose_name='название RU')),
                ('name_en', models.CharField(blank=True, max_length=255, verbose_name='название EN')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
            ],
            options={
                'verbose_name': 'страна',
                'verbose_name_plural': 'страны',
            },
        ),
        migrations.CreateModel(
            name='StaffGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('level', models.PositiveIntegerField(default=0, verbose_name='уровень')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('group_type', models.CharField(blank=True, choices=[('department', 'department'), ('service', 'service'), ('servicerole', 'servicerole'), ('wiki', 'wiki')], max_length=20, verbose_name='тип')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
                ('joined_at', models.DateTimeField(blank=True, null=True, verbose_name='дата добавления')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='staff.StaffGroup', verbose_name='родительский уровень')),
            ],
            options={
                'verbose_name': 'подразделение на Стаффе',
                'verbose_name_plural': 'подразделения',
                'ordering': ('level', 'name'),
            },
        ),
        migrations.CreateModel(
            name='StaffOffice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('code', models.CharField(max_length=255, verbose_name='код')),
                ('name_ru', models.CharField(max_length=255, verbose_name='название RU')),
                ('name_en', models.CharField(blank=True, max_length=255, verbose_name='название EN')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
                ('city', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='offices', to='staff.StaffCity', verbose_name='город')),
            ],
            options={
                'verbose_name': 'офис на Стаффе',
                'verbose_name_plural': 'офисы',
            },
        ),
        migrations.CreateModel(
            name='StaffProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('joined_at', models.DateTimeField(blank=True, null=True, verbose_name='дата выхода')),
                ('is_homeworker', models.BooleanField(default=False, verbose_name='надомник')),
                ('is_dismissed', models.BooleanField(default=False, verbose_name='бывший сотрудник')),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
                ('city', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='profiles', to='staff.StaffCity', verbose_name='город')),
                ('groups', models.ManyToManyField(to='staff.StaffGroup', verbose_name='подразделения')),
                ('office', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='profiles', to='staff.StaffOffice', verbose_name='офис')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'профиль на Стаффе',
                'verbose_name_plural': 'профили сотрудников',
            },
        ),
        migrations.AddField(
            model_name='staffcity',
            name='country',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='cities', to='staff.StaffCountry', verbose_name='страна'),
        ),
        migrations.CreateModel(
            name='StaffLeadership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('role', models.CharField(choices=[('chief', 'руководитель'), ('deputy', 'заместитель')], default='chief', max_length=20, verbose_name='роль')),
                ('joined_at', models.DateTimeField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True, verbose_name='активно')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leaderships', to='staff.StaffGroup', verbose_name='подразделение')),
                ('profile', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leaderships', to='staff.StaffProfile', verbose_name='профиль')),
            ],
            options={
                'verbose_name': 'руководство в подразделении',
                'verbose_name_plural': 'руководство в подразделениях',
                'unique_together': {('profile', 'group', 'role')},
            },
        ),
    ]
