# Generated by Django 3.0.11 on 2021-04-28 12:47

from django.db import migrations
from django_celery_beat.models import (
    DAYS
)


check_mailing_events_task_name = 'Staff: Update inactive profiles'
check_mailing_events_task_path = 'lms.staff.tasks.update_inactive_profiles'


def update_task(apps, schema_editor, days):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=DAYS,
        every=days,
    )

    task1, _ = PeriodicTask.objects.update_or_create(
        name=check_mailing_events_task_name,
        defaults={
            'task': check_mailing_events_task_path,
            'interval': interval,
            'description': 'Обновляет неактивные профили пользователей',
        },
    )


def forward(apps, schema_editor):
    update_task(apps, schema_editor, days=1)


def backward(apps, schema_editor):
    update_task(apps, schema_editor, days=7)


class Migration(migrations.Migration):

    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('staff', '0009_position_and_dismissed'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
