from rest_framework import serializers

from .models import StaffCity, StaffCountry, StaffGroup, StaffOffice


# LABAPI
# ===
class StaffLanguageListLabSerializer(serializers.Serializer):
    name = serializers.CharField()


class StaffCountryListLabSerializer(serializers.ModelSerializer):
    name = serializers.CharField(required=True)

    class Meta:
        model = StaffCountry
        fields = (
            'id', 'code', 'name'
        )
        read_only_fields = fields


class StaffCityListLabSerializer(serializers.ModelSerializer):
    name = serializers.CharField(required=True)

    class Meta:
        model = StaffCity
        fields = (
            'id', 'country_id', 'name',
        )
        read_only_fields = fields


class StaffOfficeListLabSerializer(serializers.ModelSerializer):
    name = serializers.CharField(required=True)

    class Meta:
        model = StaffOffice
        fields = (
            'id', 'city_id', 'code', 'name'
        )
        read_only_fields = fields


class StaffGroupListLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = StaffGroup
        fields = (
            'id', 'name', 'level',
        )
        read_only_fields = fields


# API
# ===
class UserIsHeadField(serializers.BooleanField):
    def to_representation(self, user):
        return user.staffprofile.subordinates.filter(is_dismissed=False).exists()


class UserIsMentorField(serializers.BooleanField):
    def to_representation(self, user):
        return user.mentorships_as_mentor.active().exists()


class UserStaffProfileDetailSerializer(serializers.Serializer):
    """
    Информация о стафф-профиле пользователя
    """
    is_head = UserIsHeadField(source='*')
    is_mentor = UserIsMentorField(source='*')

    class Meta:
        fields = (
            'is_head', 'is_mentor',
        )
        read_only_fields = fields
