from config import celery_app as app

from . import services

TASK_HOUR_LIMIT = 60 * 60


@app.task()
def get_staff_profile(user_pk: int, force_load=False):
    services.load_staff_profile(user_pk, force_load)


@app.task(soft_time_limit=TASK_HOUR_LIMIT, time_limit=TASK_HOUR_LIMIT)
def update_inactive_profiles():
    services.update_inactive_profiles()


@app.task(soft_time_limit=TASK_HOUR_LIMIT, time_limit=TASK_HOUR_LIMIT)
def update_staff_groups(**kwargs):
    services.load_staff_groups(**kwargs)


@app.task()
def update_staff_offices(**kwargs):
    services.load_staff_offices(**kwargs)


@app.task(soft_time_limit=5 * TASK_HOUR_LIMIT, time_limit=5 * TASK_HOUR_LIMIT)
def update_staff_profiles(**kwargs):
    services.load_staff_profiles(**kwargs)
