from drf_spectacular.utils import extend_schema

from django.contrib.auth import get_user_model
from django.utils.translation import gettext

from rest_framework.permissions import IsAuthenticated

from lms.core.views.viewsets import APIModelViewSet

from ..serializers import UserStaffProfileDetailSerializer

User = get_user_model()


class UserStaffProfileViewSet(APIModelViewSet):
    """
    Информация о стафф-профиле пользователя
    """
    serializer_class = UserStaffProfileDetailSerializer
    permission_classes = [
        IsAuthenticated,
    ]

    def get_object(self):
        return getattr(self.request, 'user')

    @extend_schema(
        summary=gettext("Информация о стафф-профиле пользователя"),
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)
