from django.contrib.auth import get_user_model

from .base import BaseAmmoAuth

User = get_user_model()


class TVMDebugAmmoAuth(BaseAmmoAuth):
    def __init__(self, user: User, tvm_client_id: int):
        self.tvm_client_id = tvm_client_id
        super().__init__(user)

    def __call__(self, ammo):
        ammo.headers += [
            f'Debug-Service-Id: {self.tvm_client_id}',
            f'Debug-Uid: {self.user.yauid}',
        ]
